<?php
define( 'SF_ROOT_DIR', "../../../" );
//define( 'SF_ROOT_DIR', realpath( dirname( __FILE__ ) ) );
define( 'SF_APP',      'sys' );
define( 'SF_DEBUG',    false );
require_once( SF_ROOT_DIR.DIRECTORY_SEPARATOR.'config'.DIRECTORY_SEPARATOR.'configGlobal.php' );
set_memory_max_time();

error_reporting( E_ALL );
ini_set( 'display_errors', TRUE );
ini_set( 'display_startup_errors', TRUE );
date_default_timezone_set( 'Europe/London');
define( 'EOL', ( PHP_SAPI == 'cli' ) ? PHP_EOL : '<br />' );

//----------------------------------------------------------------------------------------------------------------------------------------------------------
/** Include PHPExcel */
require_once 'PHPExcel-1.8/Classes/PHPExcel.php';
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
SELECT '' Id,
CodigoInterno, '' CodigoInterno2, ALM_ItemMast.IdItem CodigoInterno3, DescripcionCompleta, MST_UnidadMast.DescripcionCorta UNI_VENTA,
ALM_Marca.DescripcionLocal MARCA, MST_ClaseLinea.Descripcion LINEA, MST_ClaseFamilia.Descripcion FAMILIA, '' SUB_FAMILIA, NumeroDeParte, '' COD_SUNAT, '' COD_BARRAS, '' PESO,
MST_ListaPrecioDetalle.PrecioCosto, MST_ListaPrecioDetalle.PrecioVentaIGV, 100 STOCK, 1 COMPANIA, 'A1101' ALMACEN, NOW() FECHA
FROM ALM_ItemMast
  LEFT JOIN MST_UnidadMast ON ALM_ItemMast.UnidadVenta=MST_UnidadMast.IdUnidad
    LEFT JOIN ALM_Marca ON ALM_Marca.IdMarca=ALM_ItemMast.IdMarca
      LEFT JOIN MST_ClaseLinea ON MST_ClaseLinea.IdLinea=ALM_ItemMast.IdLinea
        LEFT JOIN MST_ClaseFamilia ON MST_ClaseFamilia.IdLinea=MST_ClaseLinea.IdLinea AND MST_ClaseFamilia.IdFamilia=ALM_ItemMast.IdFamilia
 LEFT JOIN MST_ListaPrecioDetalle ON MST_ListaPrecioDetalle.IdCompania=1 and MST_ListaPrecioDetalle.IdSucursal=1 and IdTipoPrecio=1 and MST_ListaPrecioDetalle.IdItem=ALM_ItemMast.IdItem
order by CodigoInterno;
;
*/
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
if( !isset( $_REQUEST['archivo'] ) )
{
    pr( "Se necesita el parametro [archivo=]" );
    exit;
}
if( isset( $_REQUEST['archivo'] ) && trim( $_REQUEST['archivo'] ) == "" )
{
    pr( "Se necesita el parametro [archivo=]" );
    exit;
}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
$s_CodigoInterno = null;
if( isset( $_REQUEST['codigo_interno'] ) )
{
    $s_CodigoInterno = $_REQUEST['codigo_interno'];
}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

$archivo = trim( $_REQUEST['archivo'] );

if ( !file_exists( $archivo ) )
{
    pr( "EL nombre del archivo [$archivo] no existe." );
    exit;
}

$tipo_igv     = 10;
$NoAfectoImpuestoVentasFlag = "N";
if( isset( $_GET['tipoigv'] ) )
{
    $tipo_igv = $_GET['tipoigv'];
}
if( $tipo_igv == 30 )
{
    $NoAfectoImpuestoVentasFlag = "S";
}

$inputFileType = PHPExcel_IOFactory::identify( $archivo );
$objReader     = PHPExcel_IOFactory::createReader( $inputFileType );
$objPHPExcel   = $objReader->load( $archivo );
$sheet         = $objPHPExcel->getSheet( 0 );
$highestRow    = $sheet->getHighestRow();
$highestColumn = $sheet->getHighestColumn();

$o_DBConnect = Conexion::getConexion();

//----------------------------------------------------------------------------------------------------------------------------------------------------------
?>

    <form method="POST" name="form1" action="" >
        <input type="hidden" name="Control" value="1">
        <input type="submit" value="GUARDAR" name="">
        <table cellspacing="0" cellspacing="0" border="1" style="font-size:12px;">
            <tr>
                <th>NRO</th>
                <th>ID</th>
                <th>CODIGO INTERNO</th>
                <th>CODIGO INTERNO 2</th>
                <th>DESCRIPCION</th>
                <th>UNIDAD VENTA</th>
                <th>COD IGV</th>
                <th>IGV DESC</th>
                <th>MARCA COD</th>
                <th>MARCA DESC</th>
                <th>LINEA COD</th>
                <th>LINEA DESC</th>
                <th>FAMILIA COD</th>
                <th>FAMILIA DESC</th>
                <th>SUB-FAMILIA COD</th>
                <th>SUB-FAMILIA DESC</th>
                <th>PARTNUMBER</th>
                <th>CODIGO SUNAT</th>
                <th>CODIGO BARRAS</th>
                <th>PESO</th>
                <th>COSTO INC IGV</th>
                <th>PRECIO INC IGV</th>
                <th>COD COMPANIA</th>
                <th>COMPANIA DESC</th>
                <th>EXISTE PROD</th>
            </tr>
            <?php
            $control_lote = null;
            $precio_prod2 = null;
            $precio_prod3 = null;

            $a_DataItem = array();
            $i = 1;
            for ( $row = 2; $row <= $highestRow; $row++ )
            {
                //if( $i != 2595 ){ continue; }
                try
                {
                    if( trim( $sheet->getCell( "E".$row )->getValue() ) )
                    {
                        $codigo_interno   = strtoupper( trim( $sheet->getCell( "A".$row )->getValue() ) );
                        $codigo_interno1  = strtoupper( trim( $sheet->getCell( "B".$row )->getValue() ) );
                        $codigo_interno2  = strtoupper( trim( $sheet->getCell( "C".$row )->getValue() ) );
                        $codigo_interno3  = strtoupper( trim( $sheet->getCell( "D".$row )->getValue() ) );
                        $producto_desc    = strtoupper( trim( $sheet->getCell( "E".$row )->getValue() ) );
                        $unidad_venta     = trim( $sheet->getCell( "F".$row )->getValue() );
                        $unidad_compra    = $unidad_venta;
                        $marca_desc       = strtoupper( trim( $sheet->getCell( "G".$row )->getValue() ) );
                        $linea_desc       = strtoupper( trim( $sheet->getCell( "H".$row )->getValue() ) );
                        $familia_desc     = strtoupper( trim( $sheet->getCell( "I".$row )->getValue() ) );
                        $sub_familia_desc = strtoupper( trim( $sheet->getCell( "J".$row )->getValue() ) );
                        $part_number      = trim( $sheet->getCell( "K".$row )->getValue() );
                        $sunat_codigo     = trim( $sheet->getCell( "L".$row )->getValue() );
                        $codigo_barras    = trim( $sheet->getCell( "M".$row )->getValue() );
                        $producto_peso    = floatval( trim( $sheet->getCell( "N".$row )->getValue() ) );
                        $costo_prod       = round( floatval( trim( $sheet->getCell( "O".$row )->getValue() ) ), 2 );      //SE ASUME QUE EL COSTO ESTA INCLUIDO EL IGV
                        $precio_prod      = round( floatval( trim( $sheet->getCell( "P".$row )->getValue() ) ), 2 );      //SE ASUME QUE EL PRECIO ESTA INCLUIDO EL IGV
                        //$precio_prod2   = round( floatval( trim( $sheet->getCell( "U".$row )->getValue() ) ), 2 );      //SE ASUME QUE EL PRECIO ESTA INCLUIDO EL IGV
                        //$precio_prod3   = round( floatval( trim( $sheet->getCell( "V".$row )->getValue() ) ), 2 );      //SE ASUME QUE EL PRECIO ESTA INCLUIDO EL IGV
                        //$control_lote   = intval( trim( $sheet->getCell( "O".$row )->getValue() ) );
                        $compania_cod     = trim( $sheet->getCell( "R".$row )->getValue() );
                        $cod_almacen      = ( trim( $sheet->getCell( "S".$row )->getValue() ) );

                        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
                        $o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $cod_almacen );
                        if( $o_ALM_AlmacenMastBN )
                        {
                            $s_IdSucursal = $o_ALM_AlmacenMastBN->getIdSucursal();
                            $s_IdComania  = $o_ALM_AlmacenMastBN->getIdCompania();

                            $s_NombreComania = $o_ALM_AlmacenMastBN->getObjectCompania()->getDescripcionCorta();
                            $s_NombreSucursal = $o_ALM_AlmacenMastBN->getDescripcionSucursal();
                        }
                        else
                        {
                            throw new Exception( "El codigo de almacen no existe." );
                        }

                        //VALIDACIONES
                        $search  = array( "'", " / ", "<B>", "<BR>", "</B>", "\\", "´´" );
                        $replace = array( '´', " ",   " ",   " ",    " ", "", "´" );
                        $marca_desc    = str_replace( $search, $replace, $marca_desc );
                        $producto_desc = str_replace( $search, $replace, $producto_desc );

                        if( strlen( $producto_desc ) >= 249 )
                        {
                            //pr( "$codigo_interno - $codigo_interno2" );
                            $producto_desc = substr( $producto_desc, 0, 249 );
                        }
                        //////////////

                        if( $s_CodigoInterno )
                        {
                            if( $codigo_interno != $s_CodigoInterno )
                            {
                                continue;
                            }
                        }

                        $s_UnidadMedidaVentaDesc = "NO EXISTE > $unidad_venta< ";
                        $s_IdUnidad              = "";

                        $s_UnidadMedidaCompraDesc = "NO EXISTE > $unidad_compra<";
                        $s_IdUnidadCompra         = "";

                        //SE FILTRA UNIDADES QUE NO EXISTE:
                        if( $unidad_venta == "CIENTO" )
                        {
                            $unidad_venta  = "CIENTO DE UNIDADES";
                            $unidad_compra = "CIENTO DE UNIDADES";
                        }
                        if( $unidad_venta == "BLISTER" )
                        {
                            $unidad_venta  = "UNIDAD";
                            $unidad_compra = "UNIDAD";
                        }
                        if( $unidad_venta == "CAJA 2" )
                        {
                            $unidad_venta  = "UNIDAD";
                            $unidad_compra = "UNIDAD";
                        }
                        if( $unidad_venta == "POR CAJA" )
                        {
                            $unidad_venta  = "CAJA";
                            $unidad_compra = "CAJA";
                        }
                        if( $unidad_venta == "POR UNIDAD" )
                        {
                            $unidad_venta  = "UNIDAD";
                            $unidad_compra = "UNIDAD";
                        }
                        if( $unidad_venta == "POR SHIPPER" )
                        {
                            $unidad_venta  = "DISPLAY";
                            $unidad_compra = "DISPLAY";
                        }
                        if( $unidad_venta == "POR DISPLAY" )
                        {
                            $unidad_venta  = "DISPLAY";
                            $unidad_compra = "DISPLAY";
                        }

                        //AHORA SE BUSCA LOS CODIGO RELACIONES CON EL SISTEMA
                        //UNIDAD DE MEDIDA POR CODIGO SUNAT - VENTA
                        $o_MST_UnidadMastFN = new MST_UnidadMastFN();
                        $o_MST_UnidadMastFN->setCodigoSunat( $unidad_venta );
                        $a_MST_UnidadMast = $o_MST_UnidadMastFN->select();
                        if( $a_MST_UnidadMast )
                        {
                            $s_UnidadMedidaVentaDesc = $a_MST_UnidadMast[0]->getDescripcionCorta();
                            $s_IdUnidad              = $a_MST_UnidadMast[0]->getIdUnidad();
                        }
                        else
                        {
                            $o_MST_UnidadMastFN = new MST_UnidadMastFN();
                            $o_MST_UnidadMastFN->setDescripcionCorta( $unidad_venta );
                            $a_MST_UnidadMast = $o_MST_UnidadMastFN->select();
                            if( $a_MST_UnidadMast )
                            {
                                $s_UnidadMedidaVentaDesc = $a_MST_UnidadMast[0]->getDescripcionCorta();
                                $s_IdUnidad              = $a_MST_UnidadMast[0]->getIdUnidad();
                            }
                            else
                            {
                                pr( "No existe la unidd de medidaa" );
                                exit;
                            }
                        }

                        //AHORA SE BUSCA LOS CODIGO RELACIONES CON EL SISTEMA
                        //UNIDAD DE MEDIDA POR CODIGO SUNAT - COMPRA
                        $o_MST_UnidadMastFN = new MST_UnidadMastFN();
                        $o_MST_UnidadMastFN->setCodigoSunat( $unidad_compra );
                        $a_MST_UnidadMast = $o_MST_UnidadMastFN->select();
                        if( $a_MST_UnidadMast )
                        {
                            $s_UnidadMedidaCompraDesc = $a_MST_UnidadMast[0]->getDescripcionCorta();
                            $s_IdUnidadCompra         = $a_MST_UnidadMast[0]->getIdUnidad();
                        }
                        else
                        {
                            $o_MST_UnidadMastFN = new MST_UnidadMastFN();
                            $o_MST_UnidadMastFN->setDescripcionCorta( $unidad_compra );
                            $a_MST_UnidadMast = $o_MST_UnidadMastFN->select();
                            if( $a_MST_UnidadMast )
                            {
                                $s_UnidadMedidaCompraDesc = $a_MST_UnidadMast[0]->getDescripcionCorta();
                                $s_IdUnidadCompra         = $a_MST_UnidadMast[0]->getIdUnidad();
                            }
                        }

                        //IMPUESTO POR CODIGO SUNAT
                        $a_DataInafectoEx = array( 20, 21, 30, 31, 32, 33, 34, 35, 36, 37, 40 );
                        $o_GSS_ImpuestoFN = new GSS_ImpuestoFN();
                        $o_GSS_ImpuestoFN->setCodigoSunat( $tipo_igv );
                        $a_GSS_Impuesto = $o_GSS_ImpuestoFN->select();
                        $s_ImpuestoDesc = "";
                        if( $a_GSS_Impuesto )
                        {
                            $s_ImpuestoDesc = $a_GSS_Impuesto[0]->getDescripcion();
                        }

                        //NUEVA MARCA:
                        //VALIDACIONES
                        if( $marca_desc == "--" ){ $marca_desc = "SIN MARCA"; }
                        if( $marca_desc == "" ){ $marca_desc = "SIN MARCA"; }

                        $i_IdMarca     = "";
                        $o_ALM_MarcaFN = new ALM_MarcaFN();
                        $o_ALM_MarcaFN->setDescripcionLocal( $marca_desc );
                        $a_ALM_Marca = $o_ALM_MarcaFN->select();
                        if( $a_ALM_Marca )
                        {
                            //LA MARCA YA EXISTE
                            $i_IdMarca  = $a_ALM_Marca[0]->getIdMarca();
                            //$marca_desc = $o_ALM_MarcaBN->getDescripcionLocal();
                        }
                        else
                        {
                            if( isset( $_POST['Control'] ) )
                            {
                                $o_ALM_MarcaDP = new ALM_MarcaDP();
                                $o_ALM_MarcaDP->setDescripcionLocal( $marca_desc );
                                $o_ALM_MarcaDP->setDescripcionIngles( "" );
                                $o_ALM_MarcaDP->setEstado( "A" );
                                $o_ALM_MarcaDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                                $o_ALM_MarcaDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                                $o_ALM_MarcaDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                                $o_ALM_MarcaDP->setUsuarioModificacion( myUser::getUser()->getUserId() );

                                $i_IdMarca = ALM_MarcaDP::recuperarId();
                                $o_ALM_MarcaDP->setIdMarca( ( string ) $i_IdMarca );
                                $o_ALM_MarcaDP->save();
                            }
                        }

                        //SE BUSCA LA CATEGORIA O LINEA
                        if( $linea_desc == "" ){ $linea_desc = "SIN LINEA"; }

                        $i_IdLinea          = "";
                        $o_MST_ClaseLineaFN = new MST_ClaseLineaFN();
                        $o_MST_ClaseLineaFN->setDescripcion( $linea_desc );
                        $a_MST_ClaseLinea = $o_MST_ClaseLineaFN->select();
                        if( $a_MST_ClaseLinea )
                        {
                            //$s_CategoriaDesc = $a_MST_ClaseLinea[0]->getDescripcion();
                            $i_IdLinea       = $a_MST_ClaseLinea[0]->getIdLinea();
                        }
                        else
                        {
                            if( isset( $_POST['Control'] ) )
                            {
                                $o_MST_ClaseLineaDP = new MST_ClaseLineaDP();
                                $o_MST_ClaseLineaDP->setDescripcion( $linea_desc );
                                $o_MST_ClaseLineaDP->setEstado( "A" );
                                $o_MST_ClaseLineaDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                                $o_MST_ClaseLineaDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                                $o_MST_ClaseLineaDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                                $o_MST_ClaseLineaDP->setUsuarioModificacion( myUser::getUser()->getUserId() );

                                $i_IdLinea = MST_ClaseLineaFN::recuperarId();
                                $Codigo = substr( $linea_desc, 0, 3 ).$i_IdLinea;
                                $o_MST_ClaseLineaDP->setCodigo( $Codigo );
                                $o_MST_ClaseLineaDP->setIdLinea( $i_IdLinea );
                                $o_MST_ClaseLineaDP->save();
                            }
                        }

                        //SE BUSCA LA SUB-CATEGORIA O FAMILIA
                        if( $familia_desc == "" ){ $familia_desc = "SIN FAMILIA"; }

                        $o_MST_ClaseFamiliaFN = new MST_ClaseFamiliaFN();
                        if( $i_IdLinea )
                        {
                            $o_MST_ClaseFamiliaFN->setIdLinea( $i_IdLinea );
                        }
                        $o_MST_ClaseFamiliaFN->setDescripcion( $familia_desc );
                        $a_MST_ClaseFamilia = $o_MST_ClaseFamiliaFN->select();
                        $i_IdFamilia        = "";
                        if( $a_MST_ClaseFamilia )
                        {
                            $i_IdFamilia        = $a_MST_ClaseFamilia[0]->getIdFamilia();
                        }
                        else
                        {
                            if( isset( $_POST['Control'] ) )
                            {
                                $o_MST_ClaseFamiliaDP = new MST_ClaseFamiliaDP();
                                $o_MST_ClaseFamiliaDP->setIdLinea( ( int ) $i_IdLinea );
                                $o_MST_ClaseFamiliaDP->setDescripcion( $familia_desc );
                                $o_MST_ClaseFamiliaDP->setEstado( "A" );
                                $o_MST_ClaseFamiliaDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                                $o_MST_ClaseFamiliaDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                                $o_MST_ClaseFamiliaDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                                $o_MST_ClaseFamiliaDP->setUsuarioModificacion( myUser::getUser()->getUserId() );

                                $i_IdFamilia = MST_ClaseFamiliaFN::recuperarIdFamilia( $i_IdLinea );
                                $Codigo = substr( $familia_desc, 0, 2 ).$i_IdFamilia;
                                $o_MST_ClaseFamiliaDP->setCodigo( $Codigo );
                                $o_MST_ClaseFamiliaDP->setIdFamilia( ( int ) $i_IdFamilia );
                                $o_MST_ClaseFamiliaDP->save();
                            }
                        }

                        //AHORA SE BUSCA LA SUB-FAMILIA
                        $i_IdSubFamilia        = "null";
                        if( $sub_familia_desc )
                        {
                            $o_MST_ClaseSubFamiliaFN = new MST_ClaseSubFamiliaFN();
                            if( $i_IdLinea )
                            {
                                $o_MST_ClaseSubFamiliaFN->setIdLinea( $i_IdLinea );
                            }
                            if( $i_IdFamilia )
                            {
                                $o_MST_ClaseSubFamiliaFN->setIdFamilia( $i_IdFamilia );
                            }
                            $o_MST_ClaseSubFamiliaFN->setDescripcion( $sub_familia_desc );
                            $a_MST_ClaseSubFamilia = $o_MST_ClaseSubFamiliaFN->select();
                            if( $a_MST_ClaseSubFamilia )
                            {
                                $i_IdSubFamilia = $a_MST_ClaseSubFamilia[0]->getIdSubFamilia();
                            }
                            else
                            {
                                if( isset( $_POST['Control'] ) )
                                {
                                    $o_MST_ClaseSubFamiliaDP = new MST_ClaseSubFamiliaDP();
                                    $o_MST_ClaseSubFamiliaDP->setIdLinea( ( int) $i_IdLinea );
                                    $o_MST_ClaseSubFamiliaDP->setIdFamilia( ( int ) $i_IdFamilia );
                                    $o_MST_ClaseSubFamiliaDP->setDescripcion( $sub_familia_desc );
                                    $o_MST_ClaseSubFamiliaDP->setEstado( "A" );
                                    $o_MST_ClaseSubFamiliaDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                                    $o_MST_ClaseSubFamiliaDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                                    $o_MST_ClaseSubFamiliaDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                                    $o_MST_ClaseSubFamiliaDP->setUsuarioModificacion( myUser::getUser()->getUserId() );

                                    $i_IdSubFamilia = MST_ClaseSubFamiliaFN::recuperarIdSubFamilia( $i_IdLinea, $i_IdFamilia );
                                    $Codigo         = substr( $sub_familia_desc, 0, 2 ).$i_IdSubFamilia;
                                    $o_MST_ClaseSubFamiliaDP->setCodigo( $Codigo );
                                    $o_MST_ClaseSubFamiliaDP->setIdSubfamilia( ( int ) $i_IdSubFamilia );
                                    $o_MST_ClaseSubFamiliaDP->save();
                                }
                            }
                        }

                        //SE BUSCA EL CODIGO DE SUNAT
                        $o_MST_ItemFiscalFN = new MST_ItemFiscalFN();
                        $o_MST_ItemFiscalFN->setCodigoFiscal( $sunat_codigo );
                        $a_MST_ItemFiscal = $o_MST_ItemFiscalFN->select();
                        $i_IdItemFiscal = "";
                        if( $a_MST_ItemFiscal )
                        {
                            $i_IdItemFiscal      = $a_MST_ItemFiscal[0]->getIdItemFiscal();
                            $s_DescripcionFiscal = $a_MST_ItemFiscal[0]->getDescripcion();
                        }

                        //SE BUSCA LA COMPAÑIA
                        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
                        $o_GSS_CompaniaFN->setIdCompania( $compania_cod );
                        $a_GSS_Compania = $o_GSS_CompaniaFN->select();
                        $s_CompaniaDesc = "";
                        if( $a_GSS_Compania )
                        {
                            $s_CompaniaDesc = $a_GSS_Compania[0]->getDescripcionCorta();
                        }

                        $s_ManejoxLoteFlag = "N";
                        if( $control_lote )
                        {
                            $s_ManejoxLoteFlag = "S";
                        }

                        //SE PREGUNTA SI YA EXISTE EL PRODUCTO
                        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
                        $s_CodigoExiste   = "NO";
                        $s_CodigoProducto = "";

                        if( $codigo_interno )
                        {

                            $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $codigo_interno );
                            if( $o_ALM_ItemMastBN )
                            {
                                $s_CodigoExiste   = "SI";
                                $s_CodigoProducto = $o_ALM_ItemMastBN->getIdItem();
                            }
                        }

                        /*
                        if( $codigo_interno1 )
                        {
                            $o_ALM_ItemMastFN->setCodigoInterno( $codigo_interno );
                            $a_ALM_ItemMast   = $o_ALM_ItemMastFN->select();
                            if( count( $a_ALM_ItemMast ) == 1 )
                            {
                                $s_CodigoExiste   = "SI";
                                $s_CodigoProducto = $a_ALM_ItemMast[0]->getIdItem();
                            }
                        }
                        if( $codigo_interno2 )
                        {
                            $o_ALM_ItemMastFN->setCodigoBarras2( $codigo_interno2 );
                            $a_ALM_ItemMast   = $o_ALM_ItemMastFN->select();
                            if( count( $a_ALM_ItemMast ) == 1 )
                            {
                                $s_CodigoExiste   = "SI";
                                $s_CodigoProducto = $a_ALM_ItemMast[0]->getIdItem();
                            }
                        }
                        */

                        if( $codigo_interno3 && !$s_CodigoProducto )
                        {
                            $o_ALM_ItemMastFN->setCodigoBarras2( $codigo_interno3 );
                            $a_ALM_ItemMast   = $o_ALM_ItemMastFN->select();
                            if( count( $a_ALM_ItemMast ) == 1 )
                            {
                                $s_CodigoExiste   = "SI";
                                $s_CodigoProducto = $a_ALM_ItemMast[0]->getIdItem();
                            }
                        }
                        else
                        {
                            if( !$s_CodigoProducto )
                            {
                                pr( "BUSCAR POR -> $producto_desc" );
                                $o_ALM_ItemMastFN = new ALM_ItemMastFN();
                                $o_ALM_ItemMastFN->setDescripcionCompleta( $producto_desc );
                                $a_ALM_ItemMast = $o_ALM_ItemMastFN->select();
                                if( count( $a_ALM_ItemMast ) == 1 )
                                {
                                    $s_CodigoExiste   = "SI";
                                    $s_CodigoProducto = $a_ALM_ItemMast[0]->getIdItem();
                                }
                            }
                        }

                        $o_ALM_ItemMastBN = new ALM_ItemMastBN();
                        if( $s_CodigoExiste == "SI" )
                        {
                            $o_ALM_ItemMastBN->setIdItem( $s_CodigoProducto );
                        }

                        $o_ALM_ItemMastBN->setIdCompania( intval( $s_IdComania ) );
                        $o_ALM_ItemMastBN->setIdSucursal( intval( $s_IdSucursal ) );
                        $o_ALM_ItemMastBN->setCodigoInterno( $codigo_interno );
                        $o_ALM_ItemMastBN->setCodigoInterno2( $codigo_interno2 );
                        $o_ALM_ItemMastBN->setCodigoBarras2( $codigo_interno3 );
                        $o_ALM_ItemMastBN->setDescripcionCompleta( $producto_desc );
                        $o_ALM_ItemMastBN->setNumeroDeParte( $part_number );
                        $o_ALM_ItemMastBN->setIdItemTipo( "01" ); //MERCADERIA
                        $o_ALM_ItemMastBN->setIdMarca( ( string ) $i_IdMarca );
                        $o_ALM_ItemMastBN->setIdLinea( $i_IdLinea );
                        $o_ALM_ItemMastBN->setIdFamilia( $i_IdFamilia );
                        $o_ALM_ItemMastBN->setIdSubFamilia( $i_IdSubFamilia );
                        $o_ALM_ItemMastBN->setIdItemFiscal( intval( $i_IdItemFiscal ) );
                        $o_ALM_ItemMastBN->setCodigoSunat( $sunat_codigo );
                        $o_ALM_ItemMastBN->setUnidadCompra( $s_IdUnidadCompra );
                        $o_ALM_ItemMastBN->setUnidadVenta( $s_IdUnidad );
                        $o_ALM_ItemMastBN->setManejoxLoteFlag( $s_ManejoxLoteFlag );
                        $o_ALM_ItemMastBN->setManejoxSerieFlag( "N" );
                        $o_ALM_ItemMastBN->setNoAfectoImpuestoVentasFlag( $NoAfectoImpuestoVentasFlag );
                        $o_ALM_ItemMastBN->setEstado( "A" );
                        $o_ALM_ItemMastBN->setIdProcedencia( "LOC" );
                        $o_ALM_ItemMastBN->setTipoGarantiaId( "18" );
                        $o_ALM_ItemMastBN->setIdTipoOperatividad( "NVO" );
                        $o_ALM_ItemMastBN->setPesoGramos( $producto_peso );
                        $o_ALM_ItemMastBN->setAfectoPercepcionIGVFlag( "N" );
                        $o_ALM_ItemMastBN->setAfectoDetraccionFlag( "NO" );
                        $o_ALM_ItemMastBN->setIdDetraccion( 0 );
                        $o_ALM_ItemMastBN->setIdPersona( 0 );
                        $o_ALM_ItemMastBN->setDescripcionLarga( "" );
                        $o_ALM_ItemMastBN->setEsInventariableFlag( "S" );
                        $o_ALM_ItemMastBN->setFusionarLoteFlag( "N" );
                        $o_ALM_ItemMastBN->setUsarDisponibleStock( "S" );
                        $o_ALM_ItemMastBN->setUsarResevableStock( "S" );
                        $o_ALM_ItemMastBN->setCodigoBarrasFabricante( $codigo_barras );

                        //POR DEFECTO SE LE ENVIA AL RANGO 1 DE PRECIO DE VENTAS
                        $o_ALM_ItemMastBN->setEsParaVenta( "SI" );
                        $o_ALM_ItemMastBN->setIdRangoVenta( 1 );                //DESCRIBE QUE RANGO PERTENECE EN LA LISTA DE PRECIOS
                        $o_ALM_ItemMastBN->setPrecioCosto( $costo_prod );                   //ESTA INCLUIDO IGV
                        $o_ALM_ItemMastBN->setPrecioVenta1( $precio_prod );
                        $o_ALM_ItemMastBN->setPrecioVenta2( $precio_prod2 );
                        $o_ALM_ItemMastBN->setPrecioVenta3( $precio_prod3 );
                        $o_ALM_ItemMastBN->setControlPrecios( true );

                        $o_ALM_ItemMastBN->setEsParaAlquiler( "NO" );
                        $o_ALM_ItemMastBN->setIdRangoAlquiler( 0 );

                        $a_DataItem[] = $o_ALM_ItemMastBN;
                        ?>
                        <tr>
                            <td align="center"><?=$i?></td>
                            <td align="center"><?=$s_CodigoProducto?></td>
                            <td align="center"><?=$codigo_interno?></td>
                            <td align="center"><?=$codigo_interno2?></td>
                            <td><?=$producto_desc?></td>
                            <td align="center"><?=$s_IdUnidad." - ".$s_UnidadMedidaVentaDesc?></td>
                            <td align="center"><?=$tipo_igv?></td>
                            <td align="center"><?=$s_ImpuestoDesc?></td>
                            <td align="center"><?=$i_IdMarca?></td>
                            <td align="center"><?=$marca_desc?></td>
                            <td align="center"><?=$i_IdLinea?></td>
                            <td align="center"><?=$linea_desc?></td>
                            <td align="center"><?=$i_IdFamilia?></td>
                            <td align="center"><?=$familia_desc?></td>
                            <td align="center"><?=$i_IdSubFamilia?></td>
                            <td align="center"><?=$sub_familia_desc?></td>
                            <td align="center"><?=$part_number?></td>
                            <td align="center"><?=$i_IdItemFiscal." - ".$sunat_codigo?></td>
                            <td align="center"><?=$codigo_barras?></td>
                            <td align="center"><?=$producto_peso?></td>
                            <td align="right"><?=number_format( $costo_prod, 2 )?></td>
                            <td align="right"><?=number_format( $precio_prod, 2 )?></td>
                            <td align="center"><?=$compania_cod?></td>
                            <td><?=$s_CompaniaDesc." - ".$s_NombreSucursal?></td>
                            <td align="center"><?=$s_CodigoExiste?></td>
                        </tr>
                        <?php $i++; ?>

                        <?php
                    }
                }
                catch ( Exception $o_Exception )
                {
                    pr( $o_Exception );
                }

                //if( $row == 10 ){ exit; }

            }
            ?>
        </table>
    </form>

<?php
if( isset( $_POST['Control'] ) )
{
    pr( "GRABAR" );

    $con = Conexion::getConexion();
    $con->begin();
    try
    {
        pr( "---------------------------------------------------------------------------------------------------------------------" );

        foreach ( $a_DataItem as $o_ALM_ItemMastBN )
        {
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //RANGO PARA SOLO UN PRECIO
            $i_IdRangoSelect = $o_ALM_ItemMastBN->getIdRangoVenta();
            if( $o_ALM_ItemMastBN->getIdRangoVenta() == 1 )
            {

                //CONFIGURACION PARA SOLO 1 PRECIO
                $a_RangoDetalle = array( 1 => array( "MINIMO" => 0.1, "MAXIMO" => 999999 ) );
            }
            else
            {
                //SE CONFIGURA PARA TRES PRECIOS
                $a_RangoDetalle = array( 2 => array( "MINIMO" => 0.1, "MAXIMO" => 5 ), 3 => array( "MINIMO" => 6, "MAXIMO" => 10 ), 4 => array( "MINIMO" => 11, "MAXIMO" => 15 ) );
            }
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            $i_IdCompania = $o_ALM_ItemMastBN->getIdCompania();
            $i_IdSucursal = $o_ALM_ItemMastBN->getIdSucursal();

            $o_ALM_ItemMastBN->setEsParaVenta( "SI" );
            $o_ALM_ItemMastBN->setIdRangoVenta( $i_IdRangoSelect );

            $o_ALM_ItemMastDP = new ALM_ItemMastDP( $o_ALM_ItemMastBN );
            if( !$o_ALM_ItemMastBN->getIdItem() )
            {
                //nuevo item
                //SE RECUPERA CORRELATIVO ITEM
                $IdItem = ALM_ItemMastFN::recuperarId();
                $o_ALM_ItemMastDP->setIdItem( $IdItem );
                $o_ALM_ItemMastDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_ALM_ItemMastDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_ALM_ItemMastDP->save();

                $o_ALM_ItemMastBN->setIdItem( $IdItem );
                pr( "es nuevo [$IdItem] [{$o_ALM_ItemMastBN->getCodigoInterno()}] " );
            }
            else
            {
                //se actualiza
                pr( "ya existe [{$o_ALM_ItemMastBN->getIdItem()}] [{$o_ALM_ItemMastBN->getCodigoInterno()}]" );
                $o_ALM_ItemMastDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_ALM_ItemMastDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_ALM_ItemMastDP->update();
            }

            //AHORA SE ACTIVA LA UNIDAD DE MEDIDA SELECCIONADA
            $o_MST_UnidadMastDP = new MST_UnidadMastDP();
            $o_MST_UnidadMastDP->setIdUnidad( $o_ALM_ItemMastBN->getUnidadVenta() );
            $o_MST_UnidadMastDP->setEstado( "A" );
            $o_MST_UnidadMastDP->setFechaModificacion( date( "Y-m-d H:i.s" ) );
            $o_MST_UnidadMastDP->setUsuarioModificacion( "wtaype" );
            $o_MST_UnidadMastDP->update();

            //ENTONCES AHORA SE ASIGNA EL COSTO Y PRECIO
            if( $o_ALM_ItemMastBN->getControlPrecios() )
            {
                //SE BUSCA LOS DETALLES
                $i_Pr = 1;
                foreach( $a_RangoDetalle as $i_IdRangoDetalle => $a_Data )
                {
                    //SE ACTUALIZA EL RANGO
                    $o_MST_RangoDetalleDP = new MST_RangoDetalleDP();
                    $o_MST_RangoDetalleDP->setIdRangoDetalle( $i_IdRangoDetalle );
                    $o_MST_RangoDetalleDP->setMinimo( $a_Data['MINIMO'] );
                    $o_MST_RangoDetalleDP->setMaximo( $a_Data['MAXIMO'] );
                    $o_MST_RangoDetalleDP->setUsuarioModificacion( "wtaype" );
                    $o_MST_RangoDetalleDP->setFechaModificacion( date( "Y-m-d H:i.s" ) );
                    $o_MST_RangoDetalleDP->update();

                    //AHORA SE BUSCA EL RANGO CON LOS DATOS CORRECTOS
                    $o_MST_RangoDetalleFN = new MST_RangoDetalleFN();
                    $o_MST_RangoDetalleBN = $o_MST_RangoDetalleFN->selectByPK( $i_IdRangoDetalle );

                    $s_NombreMetodoPrecio = "getPrecioVenta".$i_Pr;

                    $o_MST_ListaPrecioDetalleFN = new MST_ListaPrecioDetalleFN();
                    $o_MST_ListaPrecioDetalleFN->setIdCompania( $i_IdCompania );
                    $o_MST_ListaPrecioDetalleFN->setIdSucursal( $i_IdSucursal );
                    $o_MST_ListaPrecioDetalleFN->setIdItem( $o_ALM_ItemMastBN->getIdItem() );
                    $o_MST_ListaPrecioDetalleFN->setIdTipoLista( 1 ); //POR DEFECTO
                    $o_MST_ListaPrecioDetalleFN->setIdRango( $i_IdRangoSelect );
                    $o_MST_ListaPrecioDetalleFN->setIdRangoDetalle( $o_MST_RangoDetalleBN->getIdRangoDetalle() );
                    $a_MST_ListaPrecioDetalle = $o_MST_ListaPrecioDetalleFN->select();

                    $f_MontoCosto    = 0;
                    $f_MontoCostoIGV = 0;
                    if( $o_ALM_ItemMastBN->getPrecioCosto() > 0 )
                    {
                        $f_MontoCosto    = round( ( $o_ALM_ItemMastBN->getPrecioCosto() / 1.18 ), 2 );
                        $f_MontoCostoIGV = $o_ALM_ItemMastBN->getPrecioCosto();
                    }
                    $f_PrecioVenta    = round( ( $o_ALM_ItemMastBN->$s_NombreMetodoPrecio() / 1.18 ), 2 );
                    $f_PrecioVentaIGV = $o_ALM_ItemMastBN->$s_NombreMetodoPrecio();
                    $f_TotalIGV       = round( $f_PrecioVentaIGV - $f_PrecioVenta, 2 );
                    if( in_array( $tipo_igv, $a_DataInafectoEx ) )
                    {
                        if( $o_ALM_ItemMastBN->getPrecioCosto() > 0 )
                        {
                            $f_MontoCosto = $f_MontoCostoIGV;
                        }
                        $f_PrecioVenta    = $f_PrecioVentaIGV;
                        $f_TotalIGV       = 0;
                    }

                    $o_DefaultDP = new MST_ListaPrecioDetalleDP();
                    $o_DefaultDP->setIdCompania( $i_IdCompania );
                    $o_DefaultDP->setIdSucursal( $i_IdSucursal );
                    $o_DefaultDP->setIdListaPreciCab( 1 );
                    $o_DefaultDP->setIdItem( $o_ALM_ItemMastBN->getIdItem() );
                    $o_DefaultDP->setIdTipoLista( 1 );
                    $o_DefaultDP->setIdRango( $i_IdRangoSelect );
                    $o_DefaultDP->setIdRangoDetalle( $o_MST_RangoDetalleBN->getIdRangoDetalle() );
                    $o_DefaultDP->setIdTipoPrecio( "1" );
                    if( $f_MontoCosto > 0 )
                    {
                        $o_DefaultDP->setPrecioCosto( $f_MontoCosto );
                        $o_DefaultDP->setPrecioCostoIGV( $f_MontoCostoIGV );
                    }
                    $o_DefaultDP->setPrecioVenta( $f_PrecioVenta );
                    $o_DefaultDP->setMontoIGV( $f_TotalIGV );
                    $o_DefaultDP->setPrecioVentaIGV( $f_PrecioVentaIGV );
                    $o_DefaultDP->setMontoDescuento( 0 );
                    $o_DefaultDP->setPorcentajeDescuento( 0 );
                    $o_DefaultDP->setDescuentoFlag( "N" );
                    $o_DefaultDP->setEstado( "A" );

                    if( $a_MST_ListaPrecioDetalle )
                    {
                        //update
                        $i_IdDet = $a_MST_ListaPrecioDetalle[0]->getIdListaPreciDet();
                        $o_DefaultDP->setIdListaPreciDet( $i_IdDet );

                        $o_DefaultDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_DefaultDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_DefaultDP->update();
                    }
                    else
                    {
                        //insert
                        $i_IdDet = MST_ListaPrecioDetalleDP::recuperarId();

                        $o_DefaultDP->setIdListaPreciDet( $i_IdDet );

                        $o_DefaultDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                        $o_DefaultDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                        $o_DefaultDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_DefaultDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_DefaultDP->save();
                    }

                    $i_Pr++;
                }
            }

            $o_ALM_ItemMastBN->setIdCompania( 1 ); //POR DEFECTO
            $o_ALM_ItemMastBN->setIdSucursal( 1 ); //POR DEFECTO
            $o_ALM_ItemMastBN->setIdAlmacen( "A1101" ); //POR DEFECTO
            $o_ALM_ItemMastBN->setIdLote( ALM_TransaccionDetalleBN::LOTE_POR_DEFECTO );
            $o_ValidacionxItemBL = new ValidacionxItemBL();
            $o_ValidacionxItemBL->iniciarValidacionAlmacenStock( $o_ALM_ItemMastBN ); //MEJOR SE PREGUNTA DESDE LA CREACION DEL ITEM
        }

        $con->commit();
    }
    catch ( Exception $o_Exception )
    {
        $con->rollback();
        pr( $o_Exception );
    }

}